﻿using System;
using System.IO;
using System.Windows;
using System.Net;
using System.Text;
using System.Windows.Controls;
using RestSharp;
using Newtonsoft.Json;
using System.Security.Cryptography;
using static System.Net.Mime.MediaTypeNames;

namespace Submitter_COI_Requests
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
            System.Net.ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls12;

        }
        public static string getHost()
        {
            return ("apex-tst.certna.org");
        }
        public static string GetSalt(string srcUserName)
        {
            RestClient client = null;
            RestRequest request = null;
            IRestResponse response = null;

            string strSalt = null;

            string strURL = "https://" + getHost() + "/APEX/Service/APEXPublicServer.svc/user/" + srcUserName + "/salt";

            client = new RestClient(strURL);
            request = new RestRequest(Method.GET);

            request.AddHeader("Cache-Control", "no-cache");
            request.AddHeader("Content-Type", "application/json");
            response = client.Execute(request);

            if (response.IsSuccessful)
            {

                var jsonResult1 = JsonConvert.DeserializeObject<dynamic>(response.Content);
                strSalt = jsonResult1.salt;
            }

            return strSalt;
        }
        public static string HashPassword(string srcPassword, string srcSalt)
        {
            var combinedPassword = srcPassword + srcSalt;

            SHA256Managed sha256Managed = new SHA256Managed();
            UTF8Encoding utf8Encoding = new UTF8Encoding();

            // Would normally be enclosedin a try/catch block.

            return Convert.ToBase64String(sha256Managed.ComputeHash(utf8Encoding.GetBytes(combinedPassword)));
        }

        private void btnBrowseMOU_Click(object sender, RoutedEventArgs e)
        {
            // Create OpenFileDialog 
            Microsoft.Win32.OpenFileDialog dlg = new Microsoft.Win32.OpenFileDialog();

            // Set filter for file extension and default file extension 
            dlg.DefaultExt = ".pdf";
            dlg.Filter = "PDF Files (*.pdf)|*.pdf";

            // Display OpenFileDialog by calling ShowDialog method 
            Nullable<bool> result = dlg.ShowDialog();

            // Get the selected file name and display in a TextBox 
            if (result == true)
            {
                // Open the XML document and gather some info from it. 
                string strFileName = dlg.FileName;
                tbMOUFile.Text = strFileName;
            }
        }

        private void btnBrowseCOI_Click(object sender, RoutedEventArgs e)
        {
            // Create OpenFileDialog 
            Microsoft.Win32.OpenFileDialog dlg = new Microsoft.Win32.OpenFileDialog();

            // Set filter for file extension and default file extension 
            dlg.DefaultExt = ".pdf";
            dlg.Filter = "PDF Files (*.pdf)|*.pdf";

            // Display OpenFileDialog by calling ShowDialog method 
            Nullable<bool> result = dlg.ShowDialog();

            // Get the selected file name and display in a TextBox 
            if (result == true)
            {
                // Open the XML document and gather some info from it. 
                string strFileName = dlg.FileName;
                tbCOIFile.Text = strFileName;
            }

        }

        private void cbSubmitterType_SelectionChanged(object sender, System.Windows.Controls.SelectionChangedEventArgs e)
        {
            string strSubmitterType = ((sender as System.Windows.Controls.ComboBox).SelectedItem as ComboBoxItem).Content as string;

            switch(strSubmitterType)
            {
                case "Title Company":
                    tbSubmitterTypeValue.Text = "1";
                    break;
                case "Lender":
                    tbSubmitterTypeValue.Text = "2";
                    break;
                case "Government":
                    tbSubmitterTypeValue.Text = "8";
                    break;
                case "Other":
                    tbSubmitterTypeValue.Text = "32";
                    break;
                default:
                    tbSubmitterTypeValue.Text = "0";
                    break;

            }
        }

        private void sendPDFFile(string strDocType)
        {
            RestClient client = null;
            RestRequest request = null;
            IRestResponse response = null;

            string strURL = "https://" + getHost() + "/APEX/Service/APEXPublicServer.svc/user/login";

            // Password has to be hashed.
            // New convention uses a Salt value from the user record

            string strSalt = GetSalt(tbUserName.Text);
            string strPassword = tbPassword.Password.ToString();

            string strHashedPassword = HashPassword(strPassword, strSalt);

            string strParms = "{\n\t\"user_name\" : \"";
            strParms += tbUserName.Text;
            strParms += "\",\n\t\"password\" : \"";
            strParms += strHashedPassword;
            strParms += "\"\n}";

            client = new RestClient(strURL);
            request = new RestRequest(Method.POST);

            request.AddHeader("Cache-Control", "no-cache");
            request.AddHeader("Content-Type", "application/json");

            request.AddParameter("Login", strParms, ParameterType.RequestBody);
            response = client.Execute(request);

            if (response.IsSuccessful)  // Successful login and token has been received
            {
                var jsonResult1 = JsonConvert.DeserializeObject<dynamic>(response.Content);
                string token = jsonResult1.access_token;

                strURL = null;
                client = null;
                request = null;
                response = null;

                string strPDFFile = null;

                if (strDocType ==  "MOU" || strDocType == "MOURequest")
                {
                    strPDFFile = tbMOUFile.Text;
                }
                else
                {
                    strPDFFile = tbCOIFile.Text;
                }

                byte[] bytePDF = File.ReadAllBytes(strPDFFile);

                strURL = "https://" + getHost() + "/APEX/Service/APEXPublicServer.svc/postDocument";
                strURL = strURL + "?" + "documentType=" + strDocType;
                strURL = strURL + "&" + "requestID=" + tbRequestID.Text;

                client = new RestClient(strURL);
                request = new RestRequest(Method.POST);

                request.AddHeader("Cache-Control", "no-cache");
                request.AddHeader("access_token", token);
                request.AddHeader("content-type", "application/pdf");
                request.AddParameter("undefined", bytePDF, ParameterType.RequestBody);
                response = client.Execute(request);

                if (response.IsSuccessful)
                {
                    var jsonResult2 = JsonConvert.DeserializeObject<dynamic>(response.Content);

                    string strResult = jsonResult2.result;
                }
            }

            return;
        }

        private void createNewSubmitterRequest()
        {
            string strNewRequestID = "0";

            RestClient client = null;
            RestRequest request = null;
            IRestResponse response = null;

            string strURL = "https://" + getHost() + "/APEX/Service/APEXPublicServer.svc/user/login";

            // Password has to be hashed.
            // New convention uses a Salt value from the user record

            string strSalt = GetSalt(tbUserName.Text);
            string strPassword = tbPassword.Password.ToString();

            string strHashedPassword = HashPassword(strPassword, strSalt);

            string strParms = "{\n\t\"user_name\" : \"";
            strParms += tbUserName.Text;
            strParms += "\",\n\t\"password\" : \"";
            strParms += strHashedPassword;
            strParms += "\"\n}";

            client = new RestClient(strURL);
            request = new RestRequest(Method.POST);

            request.AddHeader("Cache-Control", "no-cache");
            request.AddHeader("Content-Type", "application/json");

            request.AddParameter("Login", strParms, ParameterType.RequestBody);
            response = client.Execute(request);

            if (response.IsSuccessful)  // Successfully logged in and a token has been provided
            {
                var jsonResult1 = JsonConvert.DeserializeObject<dynamic>(response.Content);
                string token = jsonResult1.access_token;

                strURL = null;
                client = null;
                request = null;
                response = null;
                
                // Note: Be sure to escape your PrimaryName, Address1, and Address2 values to avoid issues associated with invalid HTML characters appearing in the URL.

                strURL = "https://" + getHost() + "/APEX/Service/APEXPublicServer.svc/submitterRequest";

                if (tbRequestID.Text == "" || tbRequestID.Text == " " || tbRequestID.Text == "0")
                {
                    strURL = strURL + "?" + "RequestID=0";
                }
                else
                {
                    strURL = strURL + "?" + "RequestID=" + tbRequestID.Text;
                }

                strURL = strURL + "&" + "SubmitterTypeID=" + tbSubmitterTypeValue.Text;
                strURL = strURL + "&" + "PrimaryName=" + Uri.EscapeDataString(tbSubmitterName.Text);
                strURL = strURL + "&" + "Address1=" + Uri.EscapeDataString(tbAddress1.Text);
                strURL = strURL + "&" + "Address2=" + Uri.EscapeDataString(tbAddress2.Text);
                strURL = strURL + "&" + "City=" + tbCity.Text;
                strURL = strURL + "&" + "StateName=" + tbState.Text;
                strURL = strURL + "&" + "PostalCode=" + tbZipCode.Text;
                strURL = strURL + "&" + "COIExpirationDate="+tbCOIExpires.Text;

                // The following 2 properties have been added since the original release of the web service
                // If customers using the web service do not include these properties, their service call may not complete.

                if (tbSubmitterTypeValue.Text == "32")
                {
                    strURL = strURL + "&" + "UpdateMOU=true";
                    strURL = strURL + "&" + "UpdateCOI=true";
                }
                else
                {
                    strURL = strURL + "&" + "UpdateMOU=true";
                    strURL = strURL + "&" + "UpdateCOI=false";
                }

                client = new RestClient(strURL);
                request = new RestRequest(Method.POST);

                request.AddHeader("Cache-Control", "no-cache");
                request.AddHeader("access_token", token);
                request.AddHeader("content-type", "text/plain");
                //request.AddHeader("content-type", "application/x-www-form-urlencoded");
                response = client.Execute(request);

                if (response.IsSuccessful)
                {
                    var jsonResult2 = JsonConvert.DeserializeObject<dynamic>(response.Content);

                    strNewRequestID = jsonResult2.result;
                    tbRequestID.Text = strNewRequestID;
                }
            }

            return;
        }

        private void updateMOUCOIRequest()
        {
            string strUpdateRequestID = "0";

            RestClient client = null;
            RestRequest request = null;
            IRestResponse response = null;

            string strURL = "https://" + getHost() + "/APEX/Service/APEXPublicServer.svc/user/login";

            // Password has to be hashed.
            // New convention uses a Salt value from the user record

            string strSalt = GetSalt(tbUserName.Text);
            string strPassword = tbPassword.Password.ToString();

            string strHashedPassword = HashPassword(strPassword, strSalt);

            string strParms = "{\n\t\"user_name\" : \"";
            strParms += tbUserName.Text;
            strParms += "\",\n\t\"password\" : \"";
            strParms += strHashedPassword;
            strParms += "\"\n}";

            client = new RestClient(strURL);
            request = new RestRequest(Method.POST);

            request.AddHeader("Cache-Control", "no-cache");
            request.AddHeader("Content-Type", "application/json");

            request.AddParameter("Login", strParms, ParameterType.RequestBody);
            response = client.Execute(request);

            if (response.IsSuccessful)  // Successfully logged in and a token has been provided
            {
                var jsonResult1 = JsonConvert.DeserializeObject<dynamic>(response.Content);
                string token = jsonResult1.access_token;

                strURL = null;
                client = null;
                request = null;
                response = null;

                strURL = "https://" + getHost() + "/APEX/Service/APEXPublicServer.svc/updateMOUCOIRequest";

                if (tbRequestID.Text == "" || tbRequestID.Text == " " || tbRequestID.Text == "0")
                {
                    strURL = strURL + "?" + "RequestID=0";
                }
                else
                {
                    strURL = strURL + "?" + "RequestID=" + tbRequestID.Text;
                }

                strURL = strURL + "&" + "COIExpirationDate=" + tbCOIExpires.Text;
                strURL = strURL + "&" + "SubmitterID=" + tbSubmitterID.Text;
                strURL = strURL + "&" + "Address1=" + tbAddress1.Text;
                strURL = strURL + "&" + "Address2=" + tbAddress2.Text;
                strURL = strURL + "&" + "City=" + tbCity.Text;
                strURL = strURL + "&" + "StateName=" + tbState.Text;  // This property needs to be changed to StateName (2 character state abbreviation.)
                strURL = strURL + "&" + "PostalCode=" + tbZipCode.Text;
                if ((bool)cbUpdateMOU.IsChecked)
                {
                    strURL = strURL + "&" + "UpdateMOU=true";
                }
                else
                {
                    strURL = strURL + "&" + "UpdateMOU=false";
                }
                if ((bool)cbUpdateCOI.IsChecked)
                {
                    strURL = strURL + "&" + "UpdateCOI=true";
                }
                else
                {
                    strURL = strURL + "&" + "UpdateCOI=false";
                }

                client = new RestClient(strURL);
                request = new RestRequest(Method.POST);

                request.AddHeader("Cache-Control", "no-cache");
                request.AddHeader("access_token", token);
                request.AddHeader("content-type", "text/plain");
                response = client.Execute(request);

                if (response.IsSuccessful)
                {
                    var jsonResult2 = JsonConvert.DeserializeObject<dynamic>(response.Content);

                    strUpdateRequestID = jsonResult2.result;
                    tbRequestID.Text = strUpdateRequestID;

                    if ((bool)cbUpdateMOU.IsChecked)
                    {
                        // Increase the test count below to validate that runaway calls are being protected.

                        int testCtr = 0;

                        for (testCtr = 0; testCtr < 1; testCtr++)
                        {
                            // Note the following syntax
                            sendPDFFile("MOURequest");
                        }
                    }

                    if ((bool)cbUpdateCOI.IsChecked)
                    {
                        // Increase the test count below to validate that runaway calls are being protected.

                        int testCtr = 0;

                        for (testCtr = 0; testCtr < 1; testCtr++)
                        {
                            // Note the following syntax
                            sendPDFFile("COIRequest");
                        }
                    }
                }
            }

            return;
        }
        private void btnNewSubmitterRequest_Click(object sender, RoutedEventArgs e)
        {
            // New Submtter Request Workflow:
            // Create New Submitter Request - Request ID is retured.
            // Send the MOU PDF document associated with the Request ID.
            // If Submitter Type is 'Other (32) send the COI PDF document associated with the Request ID.

            createNewSubmitterRequest(); // If successfull the tbRequestID.Text field will have the new Request ID.

            sendPDFFile("MOU");

            if (tbSubmitterTypeValue.Text == "32")
            {
                sendPDFFile("COI");
            }
        }

        private void btnUpdateMOUCOIRequest_Click(object sender, RoutedEventArgs e)
        {
            // Update COI Request Workflow:
            // Create Update COI Request - Request ID is retured.
            // Send the COI PDF document associated with the Request ID.
            // Note: An existing 'Other' type submitter id is required for the Update COI request.

            updateMOUCOIRequest(); // If successfull the tbRequestID.Text field will have the new Request ID.

        }
    }
}
